/*----------------------------------------------------------------------------*/
/* sys_link.cmd                                                               */
/*                                                                            */
/* (c) Texas Instruments 2009-2016, All rights reserved.                      */
/*                                                                            */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/* Linker Settings     
                                                       */
--retain="*(.intvecs)"
--heap_size=0x800 /* Needed for printf */
--args=0

--cinit_compression=off
--copy_compression=off

/*----------------------------------------------------------------------------*/
/* Memory Map                                                                 */

MEMORY
{
/* Flash Memory */
/* Bank 0 */
    VECTORS  (X)  : origin=0x00000000                            length=0x00000020                      fill=0xffffffff
    FLASH0   (RX) : origin=(end(VECTORS))                        length=(0x0180000 - size(VECTORS))    vfill=0xffffffff /* 1.5MB */
/* Bank 1 */
    FLASH1   (RX) : origin=0x00180000                            length=0x00180000                     vfill=0xffffffff /* 1.5MB */
/* Bank 7 (FEE) */
    FLASH7   (R)  : origin=0xF0200000                            length=0x00010000                     vfill=0xffffffff /* 64kB */
/* Bank 0 ECC */
    ECC_VEC  (R)  : origin=(0xf0400000 + (start(VECTORS) >> 3))  length=(size(VECTORS) >> 3)           ECC={algorithm=algoR4F021, input_range=VECTORS, fill=false}
    ECC_FLA0 (R)  : origin=(0xf0400000 + (start(FLASH0)  >> 3))  length=(size(FLASH0)  >> 3)           ECC={algorithm=algoR4F021, input_range=FLASH0,  fill=false}
/* Bank 1 ECC */
    //ECC_FLA1 (R)  : origin=(0xf0400000 + (start(FLASH1)  >> 3))  length=(size(FLASH1)  >> 3)           ECC={algorithm=algoR4F021, input_range=FLASH1 }
/* Bank 7 ECC */
    //ECC_FLA7 (R)  : origin=0xF0100000                            length=(size(FLASH7)  >> 3)           ECC={algorithm=algoR4F021, input_range=FLASH7 }
/* embedded SRAM */
    STACKS   (RW) : origin=0x08000000                            length=0x00001500
    RAM      (RW) : origin=(end(STACKS))                         length=(0x00040000 - size(STACKS)) /* 256kB */
}

/*----------------------------------------------------------------------------*/
/* Section Configuration                                                      */

SECTIONS
{
    /* Flash based sections */
    .intvecs    : {} palign=32, fill=0xff, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > VECTORS
    .text       : {} palign=8, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > FLASH0 | FLASH1 /* Executable code and constants */
    .const      : {} palign=8, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > FLASH0 | FLASH1 /* Global and static const variables that are explicitly initialized */
    //.binit      : {} palign=8, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > FLASH0 | FLASH1 /* Boot time copy tables */
    .cinit      : {} palign=8, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > FLASH0 | FLASH1 /* Tables for explicitly initialized global and static variables */
#ifdef __TI_EABI_SUPPORT__
    //.init_array : {} palign=8, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > FLASH0 | FLASH1 /* C++ global constructor addresses */
#else /* TI_ARM9_ABI and TIABI */
    .pinit      : {} palign=8, crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) > FLASH0 | FLASH1 /* C++ global constructor addresses */
#endif

    /* Special TI Sections */
    //.TI.ramfunc : {} palign=8, load=FLASH0, run=RAM, table(BINIT), crc_table(_my_crc_table, algorithm=TMS570_CRC64_ISO) /* Section for the ramfunc attribute */
    .TI.crctab  : {} palign=8 > FLASH0 | FLASH1 /* The CRC tables generated by the linker are created in the special section .TI.crctab */

	/* RAM based sections */
    .stack      : {__STACK_START = .;} type=NOINIT > STACKS /* Stack */
    .bss        : {} palign=8 > RAM    /* Uninitialized global and static variables */
    .data       : {} palign=8 > RAM    /* Global and static non-const variables that are explicitly initialized. */
    .sysmem     : {} > RAM    /* Memory pool (heap) for dynamic memory allocation */
}

/*----------------------------------------------------------------------------*/
/* Misc                                                                       */

ECC {
    algoR4F021 : address_mask = 0x003ffff8 /* Address Bits 21:3 */
                 hamming_mask = R4         /* Use R4 build in Mask */
                 parity_mask  = 0x0c       /* Set which ECC bits are Even and Odd parity */
                 mirroring    = F021       /* RM4x are build in F021 */
}

/*----------------------------------------------------------------------------*/
